package ru.yandex.travel.orders.services.payments.model.plus;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.travel.orders.services.payments.model.TrustBasketStatusResponse;
import ru.yandex.travel.orders.services.payments.model.TrustStartPaymentResponse;

/**
 * The response is almost similar to {@link TrustBasketStatusResponse}. Probably it's exactly similar, just
 * TrustBasketStatusResponse is not 100% up to date.
 *
 * Example:
 * <pre>
 * {"status": "success", "basket_rows": [{"order_id": "161994502", "amount": "100000.00", "quantity": "0.00"}],
 * "payment_url": "https://trust-test.yandex.ru/web/payment?purchase_token=3159103c93133b80f56fc00ab05ad1d8",
 * "payment_status": "started", "start_ts": "1626954405.211", "orders": [{"product_type": "app", "uid": "4003404817",
 *   "paid_amount": "0.00", "current_amount": [], "order_ts": "1626954230.683", "current_qty": "0.00",
 *   "order_id": "161994502", "orig_amount": "100000.00", "product_name": "TestTestAppProduct",
 *   "product_id": "1185272925398809663"}],
 * "currency": "RUB", "amount": "100000.00", "payment_timeout": "1200.000",
 * "purchase_token": "3159103c93133b80f56fc00ab05ad1d8", "uid": "4003404817"}
 * </pre>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class TrustTopupStartResponse extends TrustStartPaymentResponse {
}
