package ru.yandex.travel.tvm;

import lombok.AccessLevel;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor(access = AccessLevel.PRIVATE)
public class ServiceTicketCheck {
    public static final ServiceTicketCheck VALID = new ServiceTicketCheck(ServiceTicketCheckStatus.OK, null);

    private final ServiceTicketCheckStatus status;
    private final String description;

    public static ServiceTicketCheck invalid(ServiceTicketCheckStatus status, String description) {
        return new ServiceTicketCheck(status, description);
    }

    public boolean isOk() {
        return status == ServiceTicketCheckStatus.OK;
    }

    public ServiceTicketCheckStatus getStatus() {
        return status;
    }

    public String getDescription() {
        return description;
    }
}
