package ru.yandex.travel.tvm;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableBiMap;

import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.inside.passport.tvm2.TvmClientCredentials;
import ru.yandex.travel.PropertyUtils;

import static java.util.stream.Collectors.toMap;

public class TvmHelper {
    private TvmHelper() {
    }

    public static Tvm2 getTvmInstance(TvmProperties properties, List<Integer> dstClientIds) {
        properties.validate();
        TvmClientCredentials credentials = new TvmClientCredentials(properties.getClientId(),
                properties.getClientSecret());
        Tvm2 tvm = new Tvm2(credentials);
        if (properties.getBlackboxEnv() != null) {
            tvm.setBlackboxEnv(properties.getBlackboxEnv());
        }
        if (dstClientIds != null) {
            tvm.setDstClientIds(dstClientIds);
        }
        tvm.start();
        return tvm;
    }

    public static TvmWrapper getTvmWrapper(TvmProperties properties) {
        ImmutableBiMap<String, Integer> aliases = parseAliases(properties);
        List<Integer> dstIds = null;
        if (!Strings.isNullOrEmpty(properties.getDstServiceAliases())) {
            dstIds = PropertyUtils.stringToListOfStrings(properties.getDstServiceAliases()).stream()
                    .map(alias -> {
                        if (!aliases.containsKey(alias)) {
                            throw new IllegalArgumentException("No such alias: " + alias);
                        } else {
                            return aliases.get(alias);
                        }
                    })
                    .collect(Collectors.toList());
        }
        return new TvmWrapperImpl(getTvmInstance(properties, dstIds), aliases, properties.getClientId());
    }

    private static ImmutableBiMap<String, Integer> parseAliases(TvmProperties properties) {
        return ImmutableBiMap.copyOf(PropertyUtils.stringToMap(properties.getServiceAliasIdMapping()).entrySet().stream()
                .collect(toMap(Map.Entry::getKey, e -> Integer.valueOf(e.getValue()))));
    }
}
