package ru.yandex.travel.tvm;

import com.google.common.base.Preconditions;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import ru.yandex.passport.tvmauth.BlackboxEnv;

@Getter
@Setter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TvmProperties {
    private Integer clientId;
    private String clientSecret;

    private String serviceAliasIdMapping;
    private String dstServiceAliases;
    private BlackboxEnv blackboxEnv;

    private boolean enabled;

    public void validate() {
        if (enabled) {
            Preconditions.checkArgument(clientId != null, "Client id must be provided if TVM is enabled");
            Preconditions.checkArgument(clientSecret != null, "Client secret must be provided if TVM is enabled");
            Preconditions.checkArgument(!clientSecret.isEmpty(), "Provided client secret must be not blank if TVM is enabled");
        }
    }
}
