package ru.yandex.travel.tvm;

import java.util.Collection;
import java.util.Optional;

public interface TvmWrapper extends AutoCloseable {
    int getSelfTvmId();

    void validateAlias(String alias) throws IllegalArgumentException;

    void validateAliases(Collection<String> aliases) throws IllegalArgumentException;

    String getServiceTicket(String alias);

    Optional<String> getServiceTicketOptional(String alias);

    ServiceTicketCheck checkServiceTicket(String serviceTicket, Collection<String> allowedSources);

    UserTicketCheck checkUserTicket(String userTicket, Long passportId);

    boolean isInitialized();

    @Override
    void close();
}
