package ru.yandex.travel.tvm;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
@Getter
public class UserTicketCheck {
    private final UserTicketCheckStatus status;
    private final String description;
    private final Long defaultUid;

    public boolean isOk() {
        return status == UserTicketCheckStatus.OK;
    }

    public static UserTicketCheck valid(Long defaultUid) {
        return new UserTicketCheck(UserTicketCheckStatus.OK, null, defaultUid);
    }

    public static UserTicketCheck invalid(UserTicketCheckStatus status, String description) {
        return new UserTicketCheck(status, description, null);
    }
}
