package ru.yandex.travel.tx.utils;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Aspect
public class TransactionMandatoryAdvice {

    private final PlatformTransactionManager platformTransactionManager;
    private final DefaultTransactionDefinition mandatoryTransactionDefinition =
            new DefaultTransactionDefinition(TransactionDefinition.PROPAGATION_MANDATORY);

    public TransactionMandatoryAdvice(PlatformTransactionManager platformTransactionManager) {
        this.platformTransactionManager = platformTransactionManager;
    }

    @Before("execution(* *.*(..)) && @annotation(TransactionMandatory) ")
    public void before(JoinPoint joinPoint) {
        platformTransactionManager.getTransaction(mandatoryTransactionDefinition);
    }
}
