package ru.yandex.travel.tx.utils;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ConditionalOnClass(PlatformTransactionManager.class)
public class TransactionMandatoryAutoConfiguration {

    @Bean
    public TransactionMandatoryAdvice transactionMandatoryAdvice(PlatformTransactionManager platformTransactionManager) {
        return new TransactionMandatoryAdvice(platformTransactionManager);
    }
}
