package ru.yandex.travel.workflow;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;

public class BasicMessagingContext<E> implements MessagingContext<E> {
    private UUID workflowId;
    private final Integer workflowVariant;
    private E workflowEntity;
    private List<WorkflowMessagePair> scheduledExternalEvents;
    private final int attempt;

    public BasicMessagingContext(UUID workflowId, E workflowEntity, int attempt, Integer workflowVersion) {
        this.workflowEntity = workflowEntity;
        this.scheduledExternalEvents = new ArrayList<>();
        this.workflowId = workflowId;
        this.attempt = attempt;
        this.workflowVariant = workflowVersion;
    }

    @Override
    public UUID getWorkflowId() {
        return workflowId;
    }

    @Override
    public Integer getWorkflowVersion() {
        return workflowVariant;
    }

    @Override
    public E getWorkflowEntity() {
        return workflowEntity;
    }

    @Override
    public void scheduleEvent(Message event) {
        scheduleExternalEvent(workflowId, event);
    }

    @Override
    public void scheduleExternalEvent(UUID workflowId, Message messageEvent) {
        scheduledExternalEvents.add(new WorkflowMessagePair(workflowId, messageEvent));
    }

    @Override
    public List<WorkflowMessagePair> getScheduledEvents() {
        return ImmutableList.copyOf(scheduledExternalEvents);
    }

    @Override
    public int getAttempt() {
        return attempt;
    }
}
