package ru.yandex.travel.workflow;

import java.util.List;
import java.util.UUID;

import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;

import ru.yandex.travel.workflow.entities.WorkflowEntity;

public class BasicStateMessagingContext<S extends ProtocolMessageEnum, E extends WorkflowEntity<S>> implements StateContext<S, E> {

    private MessagingContext<E> messagingContext;

    private BasicStateMessagingContext(MessagingContext<E> messagingContext) {
        this.messagingContext = messagingContext;
    }

    public static <S extends ProtocolMessageEnum, E extends WorkflowEntity<S>> BasicStateMessagingContext<S, E> fromMessagingContext(MessagingContext<E> ctx) {
        return new BasicStateMessagingContext<>(ctx);
    }

    @Override
    public S getState() {
        return messagingContext.getWorkflowEntity().getState();
    }

    @Override
    public void setState(S newState) {
        messagingContext.getWorkflowEntity().setState(newState);
    }

    @Override
    public UUID getWorkflowId() {
        return messagingContext.getWorkflowId();
    }

    @Override
    public Integer getWorkflowVersion() {
        return messagingContext.getWorkflowVersion();
    }

    @Override
    public E getWorkflowEntity() {
        return messagingContext.getWorkflowEntity();
    }

    @Override
    public void scheduleEvent(Message event) {
        messagingContext.scheduleEvent(event);
    }

    @Override
    public void scheduleExternalEvent(UUID workflowId, Message event) {
        messagingContext.scheduleExternalEvent(workflowId, event);
    }

    @Override
    public List<WorkflowMessagePair> getScheduledEvents() {
        return messagingContext.getScheduledEvents();
    }

    @Override
    public int getAttempt() {
        return messagingContext.getAttempt();
    }
}
