package ru.yandex.travel.workflow;

import java.util.Map;
import java.util.Set;
import java.util.UUID;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.tx.utils.TransactionMandatory;
import ru.yandex.travel.workflow.repository.WorkflowRepository;

@RequiredArgsConstructor
public class BatchPendingWorkflowsFetcher implements PendingWorkflowsFetcher {

    private final WorkflowRepository workflowRepository;

    @Override
    @TransactionMandatory
    public Map<UUID, Integer> fetchPendingWorkflows(Integer defaultProcessingPoolId, Set<UUID> excludedWorkflowIds,
                                                    Map<Integer, Integer> poolLimits) {
        return workflowRepository.findWorkflowsToBeScheduledByPools(excludedWorkflowIds, defaultProcessingPoolId,
                poolLimits);
    }
}
