package ru.yandex.travel.workflow;

import java.time.Duration;

import ru.yandex.travel.workflow.exceptions.TooManyRequestsRetryableException;

public class DefaultWorkflowEventRetryStrategy implements WorkflowEventRetryStrategy {
    @Override
    public Duration getWaitDuration(int iteration, Exception ex) {
        if (ex instanceof TooManyRequestsRetryableException) {
            return getTooManyRequestsWaitDuration(iteration, (TooManyRequestsRetryableException) ex);
        }
        return getDefaultWaitDuration(iteration, ex);
    }

    private Duration getDefaultWaitDuration(int iteration, Exception ex) {
        if (iteration < 5) {
            return Duration.ofMillis(2000);
        } else if (iteration < 10) {
            return Duration.ofMillis(7000);
        } else {
            return Duration.ofMillis(22000);
        }
    }

    private Duration getTooManyRequestsWaitDuration(int iteration, TooManyRequestsRetryableException ex) {
        if (iteration < 1) {
            return Duration.ofMillis(5000);
        } else if (iteration < 2) {
            return Duration.ofMillis(15000);
        } else if (iteration < 3) {
            return Duration.ofMillis(30000);
        } else {
            return Duration.ofMillis(60000);
        }
    }

    @Override
    public boolean shouldRetry(int iteration, Exception ex) {
        return iteration <= 25;
    }
}
