package ru.yandex.travel.workflow;

import java.util.List;
import java.util.UUID;

import com.google.protobuf.Message;

public interface MessagingContext<E> {

    UUID getWorkflowId();

    Integer getWorkflowVersion();

    E getWorkflowEntity();

    void scheduleEvent(Message event);

    void scheduleExternalEvent(UUID workflowId, Message event);

    List<WorkflowMessagePair> getScheduledEvents();

    int getAttempt();
}
