package ru.yandex.travel.workflow;

import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;

import ru.yandex.travel.workflow.entities.WorkflowEntity;


public class MessagingUtils {
    public static <S extends ProtocolMessageEnum, T extends WorkflowEntity<S>> void
    throwOnUnmatchedEvent(Message event,
                          StateContext<S, T> stateContext) {
        throw new IllegalArgumentException(
                String.format("Don't know how to handle message of type %s in state %s", event.getClass(),
                        stateContext.getState())
        );
    }

    public static <T> void throwOnUnmatchedEvent(
            Message event, MessagingContext<T> messagingContext) {
        T entity = messagingContext.getWorkflowEntity();
        String entityType = entity instanceof WorkflowEntity ?
                ((WorkflowEntity<?>) entity).getEntityType() : entity.getClass().getSimpleName();
        throw new IllegalArgumentException(
                String.format("Don't know how to handle message of type %s for workflow %s of type %s", event.getClass(),
                        messagingContext.getWorkflowId().toString(), entityType)
        );
    }
}
