package ru.yandex.travel.workflow;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.support.TransactionTemplate;


@ConditionalOnProperty("protobuf-enum-dictionary.enabled")
@Configuration
public class ProtobufEnumDictionaryConfiguration {

    @ConfigurationProperties(prefix = "protobuf-enum-dictionary", ignoreUnknownFields = false)
    @Bean
    ProtobufEnumDictionaryService.Properties protobufEnumDictionaryProperties() {
        return new ProtobufEnumDictionaryService.Properties();
    }

    @Bean
    ProtobufEnumDictionaryService protobufEnumDictionaryService(TransactionTemplate transactionTemplate,
                                                                JdbcTemplate jdbcTemplate,
                                                                ProtobufEnumDictionaryService.Properties properties) {
        return new ProtobufEnumDictionaryService(transactionTemplate, jdbcTemplate, properties);
    }


}
