package ru.yandex.travel.workflow;

import java.util.Map;

import io.sentry.Sentry;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import org.slf4j.MDC;

public class SentryHelper {
    public static void reportCrashExceptionToSentry(Exception ex, String scope) {
        EventBuilder eventBuilder = new EventBuilder().withMessage(ex.getMessage())
                .withLevel(Event.Level.ERROR)
                .withSentryInterface(new ExceptionInterface(ex));
        sendEvent(eventBuilder, scope);
    }

    public static void reportMessageToSentry(String message, String scope) {
        EventBuilder eventBuilder = new EventBuilder().withMessage(message)
                .withLevel(Event.Level.INFO);
        sendEvent(eventBuilder, scope);
    }

    private static void sendEvent(EventBuilder eventBuilder, String scope) {
        for (Map.Entry<String, String> kv : MDC.getCopyOfContextMap().entrySet()) {
            eventBuilder.withTag(kv.getKey(), kv.getValue());
        }
        eventBuilder.withTag("Scope", scope);
        Sentry.getStoredClient().sendEvent(eventBuilder);
    }
}

