package ru.yandex.travel.workflow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.tx.utils.TransactionMandatory;
import ru.yandex.travel.workflow.repository.WorkflowRepository;

@RequiredArgsConstructor
public class SequentialPendingWorkflowsFetcher implements PendingWorkflowsFetcher {

    private final WorkflowRepository workflowRepository;

    @Override
    @TransactionMandatory
    public Map<UUID, Integer> fetchPendingWorkflows(Integer defaultProcessingPoolId,
                                                    Set<UUID> excludedWorkflowIds,
                                                    Map<Integer, Integer> poolLimits) {
        Map<UUID, Integer> workflowsAndPools = new HashMap<>();
        for (Map.Entry<Integer, Integer> limitEntry : poolLimits.entrySet()) {
            int poolId = limitEntry.getKey();
            int limit = limitEntry.getValue();
            if (limit == 0) {
                continue;
            }
            List<UUID> workflowIds;
            if (poolId == defaultProcessingPoolId) {
                // backward compatibility: process all other workflows,
                // including old ones without or with not existing pool ids
                Set<Integer> excludedPoolIds = poolLimits.keySet().stream()
                        .filter(id -> id != poolId)
                        .collect(Collectors.toSet());
                workflowIds = workflowRepository.findWorkflowsToBeScheduled(
                        excludedWorkflowIds, excludedPoolIds, limit);
            } else {
                workflowIds = workflowRepository.findWorkflowsToBeScheduled(
                        excludedWorkflowIds, poolId, limit);
            }
            workflowIds.forEach(id -> workflowsAndPools.put(id, poolId));
        }
        return workflowsAndPools;
    }
}
