package ru.yandex.travel.workflow;

import com.google.protobuf.ProtocolMessageEnum;

import ru.yandex.travel.workflow.entities.WorkflowEntity;

/**
 * Wrapper for state context data. Used to:
 * get the current state of state machine
 * set the final state after event signalling
 * to signal new events
 */
public interface StateContext<S extends ProtocolMessageEnum, E extends WorkflowEntity<S>> extends MessagingContext<E> {
    /**
     * @return Object that workflow is attached to
     */
    S getState();

    void setState(S newState);
}
