package ru.yandex.travel.workflow;

import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.Executors;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.support.TransactionTemplate;

import ru.yandex.travel.workflow.repository.WorkflowEventRepository;

@Configuration
@RequiredArgsConstructor
public class WorkflowMessageSenderConfiguration {
    private final WorkflowEventQueue workflowEventQueue;

    private final TransactionTemplate transactionTemplate;

    private final WorkflowEventRepository workflowEventRepository;

    private final Clock clock;

    @Bean
    public WorkflowEventStatePoller workflowEventStatePoller() {
        //TODO (mbobrov): make it configurable
        WorkflowEventStatusRegistry registry = new WorkflowEventStatusRegistry(
                clock,
                Duration.ofMillis(1000),
                Executors.newFixedThreadPool(10,
                        new ThreadFactoryBuilder().setNameFormat("WorkflowEventStatus").build()
                )
        );
        return new WorkflowEventStatePoller(transactionTemplate, workflowEventRepository, registry);
    }

    @Bean
    public WorkflowMessageSender workflowMessageSender(WorkflowEventStatePoller workflowEventStatePoller) {
        return new WorkflowMessageSender(workflowEventQueue, workflowEventStatePoller);
    }
}
