package ru.yandex.travel.workflow;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface WorkflowProcessService {
    Logger WF_EVENTS_LOGGER =
            LoggerFactory.getLogger("ru.yandex.travel.workflows.processing.EventsLogger");

    Logger WF_ENTITY_EVENTS_LOGGER =
            LoggerFactory.getLogger("ru.yandex.travel.workflows.processing.EntityEventsLogger");

    void stop() throws Exception;

    /**
     * Deprecated: use {@link WorkflowMessageSender} instead
     * direct use of workflow process service tends to create circular dependencies
     */
    @Deprecated
    void scheduleEvent(UUID workflowId, Message eventData);

    @VisibleForTesting
    CompletableFuture<Void> scheduleEventWithLocalTracking(UUID workflowId, Message eventData);

    void pauseAll();

    int getWorkflowsInProcessCount();

    int getMaxWorkflows();

    int getPendingWorkflowsCount();

    void resume();

    /**
     * The implementation may rely on an external update scheduler & transaction to refresh its processing metrics.
     * Should be called from the service code if detailed stats are needed.
     */
    void updateMetrics();
}
