package ru.yandex.travel.workflow;

import java.time.Duration;
import java.util.Map;
import java.util.Set;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix = "workflow-processing", ignoreUnknownFields = false)
@Validated
@Getter
@Setter
public class WorkflowProcessingProperties {
    @NotNull
    @Valid
    private ProcessingPools processingPools;
    @NotNull
    private Integer delayedRetriesLimit;
    @NotNull
    private ConcurrencyFailure concurrencyFailure;
    @NotNull
    private Duration pendingWorkflowPollingInterval;

    private boolean useSavepoints;

    private boolean useProcessingPools;

    @Validated
    @Getter
    @Setter
    public static class ConcurrencyFailure {
        @NotNull
        private Integer retryCount;
        @NotNull
        private Duration maxTimeout;
    }

    @Validated
    @Getter
    @Setter
    public static class ProcessingPools {
        @NotNull
        private Integer defaultPoolId;

        private WorkflowPoolSchedulingMode schedulingMode;

        @NotEmpty
        @Valid
        private Map<Integer, PoolInfo> pools;
    }

    @Validated
    @Getter
    @Setter
    public static class PoolInfo {
        private String name;
        @Positive
        private Integer threads;
        @NotNull
        private Set<String> entityTypes;
    }
}
