package ru.yandex.travel.workflow.base;

import com.google.protobuf.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;

@Service
@Slf4j
public class IgnoreMessagesHandler implements StatefulWorkflowEventHandler {
    @Override
    public void handleEvent(Message event, StateContext stateContext) {
        log.info("Ignoring message for workflow {} in state {}", stateContext.getWorkflowId(), stateContext.getState());
    }
}
