package ru.yandex.travel.workflow.entities;

import java.time.Instant;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import com.google.protobuf.Message;
import lombok.Data;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;

@Entity
@Table(name = "client_calls")
@Data
public class ClientCall {
    @Id
    private String id;

    @Type(type = "protobuf-value")
    @Columns(columns = {
            @Column(name = "response_class_name"), @Column(name = "response_data")
    })
    private Message response;

    @CreationTimestamp
    private Instant createdAt;
}
