package ru.yandex.travel.workflow.entities;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import lombok.Data;

@Entity
@Table(name = "entity_state_transitions")
@Data
public class EntityStateTransition {
    @Id
    @GeneratedValue(
            strategy = GenerationType.SEQUENCE,
            generator = "entity_state_transition_id_seq"
    )
    @SequenceGenerator(
            name = "entity_state_transition_id_seq",
            sequenceName = "entity_state_transition_id_seq",
            allocationSize = 1
    )
    private Long id;
    private UUID workflowId;
    private UUID entityId;
    private String entityType;
    private Integer fromState;
    private Instant previousTransitionAt;
    private Integer toState;
    private Instant transitionAt;
}
