package ru.yandex.travel.workflow.entities;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Version;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.Data;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.UpdateTimestamp;

import ru.yandex.travel.workflow.single_operation.proto.ESingleOperationState;

@Entity
@Table(name = "single_operations")
@Data
public class SingleOperation implements WorkflowEntity<ESingleOperationState> {
    @Id
    private UUID id;

    private String uniqueName;

    private String name;

    @Type(type = "jsonb-node")
    private JsonNode input;

    @Type(type = "jsonb-node")
    private JsonNode output;

    private String operationType;

    private Instant scheduledAt;

    private boolean commitSent;

    @OneToOne
    private Workflow workflow;

    private Instant lastTransitionAt;

    @Type(type = "proto-enum")
    private ESingleOperationState state;

    @CreationTimestamp
    private Instant createdAt;

    @UpdateTimestamp
    private Instant updatedAt;

    @Version
    private Integer version;

    @Override
    public String getEntityType() {
        return CommonWorkflowTypes.SINGLE_OPERATION.getDiscriminatorValue();
    }
}
