package ru.yandex.travel.workflow.entities;

import java.time.Instant;
import java.util.UUID;

import com.google.protobuf.ProtocolMessageEnum;

import ru.yandex.travel.commons.logging.LogEntity;

public interface WorkflowEntity<E extends ProtocolMessageEnum> extends LogEntity {
    UUID getId();

    String getEntityType();

    Workflow getWorkflow();

    void setWorkflow(Workflow workflow);

    Instant getLastTransitionAt();

    void setLastTransitionAt(Instant instant);

    void setState(E state);

    E getState();

    @Override
    default UUID getLogEntityId() {
        return getId();
    }

    @Override
    default String getLogEntityType() {
        return getEntityType();
    }
}
