package ru.yandex.travel.workflow.entities;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import com.google.protobuf.Message;
import lombok.Data;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;

import ru.yandex.travel.workflow.EWorkflowEventState;

@Entity
@Table(name = "workflow_events")
@Data
public class WorkflowEvent {

    @Id
    @GeneratedValue(
            strategy = GenerationType.SEQUENCE,
            generator = "workflow_events_id_seq"
    )
    @SequenceGenerator(
            name = "workflow_events_id_seq",
            sequenceName = "workflow_events_id_seq",
            allocationSize = 1
    )
    private Long id;

    private UUID workflowId;

    @Type(type = "proto-enum")
    private EWorkflowEventState state;

    @Type(type = "protobuf-value")
    @Columns(columns = {
            @Column(name = "class_name"), @Column(name = "data")
    })
    private Message data;


    @CreationTimestamp
    @Column(name = "created_at", updatable = false)
    private Instant createdAt;

    private Instant processedAt;

    private int timesTried;

    public static WorkflowEvent createEventFor(UUID workflowId, Message message) {
        WorkflowEvent result = new WorkflowEvent();
        result.setWorkflowId(workflowId);
        result.setData(message);
        result.setState(EWorkflowEventState.WES_NEW);
        return result;
    }
}
