package ru.yandex.travel.workflow.entities;

import java.time.Instant;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;

import ru.yandex.travel.workflow.EWorkflowState;

@Entity
@Table(name = "workflow_state_transitions")
@Data
@EqualsAndHashCode(exclude = {"workflow"})
@ToString(exclude = {"workflow"})
public class WorkflowStateTransition {

    @Id
    @GeneratedValue(
            strategy = GenerationType.SEQUENCE,
            generator = "workflow_state_transitions_id_seq"
    )
    @SequenceGenerator(
            name = "workflow_state_transitions_id_seq",
            sequenceName = "workflow_state_transitions_id_seq",
            allocationSize = 1
    )
    private Long id;

    @ManyToOne
    @JoinColumn(name = "workflow_id")
    private Workflow workflow;

    private EWorkflowState fromState;

    private EWorkflowState toState;

    @Type(type = "protobuf-value")
    @Columns(columns = {
            @Column(name = "data_class_name"), @Column(name = "data")
    })
    private Object data;

    @CreationTimestamp
    private Instant createdAt;
}
