package ru.yandex.travel.workflow.exceptions;

import java.time.Duration;

import lombok.Getter;

public class RetryableException extends RuntimeException {
    @Getter
    private Duration waitDuration;

    public RetryableException(String message) {
        super(message);
    }

    public RetryableException(String message, Duration waitDuration) {
        super(message);
        this.waitDuration = waitDuration;
    }

    public RetryableException(Throwable cause) {
        super(cause);
    }

    public RetryableException(Throwable cause, Duration waitDuration) {
        super(cause);
        this.waitDuration = waitDuration;
    }

    public RetryableException(String message, Throwable cause) {
        super(message, cause);
    }

    public RetryableException(String message, Throwable cause, Duration waitDuration) {
        super(message, cause);
        this.waitDuration = waitDuration;
    }
}
