package ru.yandex.travel.workflow.ha;

import javax.sql.DataSource;

import com.google.common.collect.ImmutableList;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.spring.tx.ForcedRollbackTxManagerWrapper;
import ru.yandex.travel.task_processor.TaskProcessor;
import ru.yandex.travel.workflow.WorkflowProcessService;

@Configuration
public class HAConfiguration {

    @Bean
    public MasterAwareResourceManager masterAwareResourceManager(@Autowired ApplicationContext applicationContext,
                                                                 @Autowired WorkflowProcessService workflowProcessService,
                                                                 @Autowired ForcedRollbackTxManagerWrapper forcedRollbackTxManagerWrapper) {

        ImmutableList.Builder<TaskProcessor<?>> listBuilder = ImmutableList.builder();
        applicationContext.getBeansOfType(TaskProcessor.class).values().forEach(listBuilder::add);

        return new MasterAwareResourceManager(workflowProcessService,
            forcedRollbackTxManagerWrapper, listBuilder.build());
    }

    @Configuration
    @EnableConfigurationProperties(HAConfigurationProperties.class)
    @ConditionalOnProperty("high-availability.enabled")
    @AllArgsConstructor
    public static class HAMasterLockConfiguration {

        private final DataSource dataSource;

        private final HAConfigurationProperties haConfigurationProperties;

        private final MasterAwareResourceManager masterAwareResourceManager;

        @Bean
        public DBMasterLockManager dbMasterLockManager() {
            return new DBMasterLockManager(
                dataSource,
                haConfigurationProperties.getMasterLockInitialPingDelayDuration(),
                haConfigurationProperties.getMasterLockPingDuration(),
                haConfigurationProperties.getMasterPingQueryTimeoutSeconds()
            );
        }

        @Bean
        public HAManager haManager(DBMasterLockManager dbMasterLockManager) {
            return new HAManager(
                dbMasterLockManager, masterAwareResourceManager,
                haConfigurationProperties.getPromoteDuration(),
                haConfigurationProperties.getStopDuration(),
                haConfigurationProperties.getRetryAcquireMasterLockDuration()
            );
        }
    }

    @Configuration
    @ConditionalOnProperty(value = "high-availability.enabled", havingValue = "false", matchIfMissing = true)
    @EnableConfigurationProperties(SingleNodeConfigurationProperties.class)
    public static class SingleNodeConfiguration {

        @Bean
        public WorkflowProcessHAManagerAdapter workflowProcessHAManagerAdapter(MasterAwareResourceManager masterAwareResourceManager,
                                                                               SingleNodeConfigurationProperties properties) {
            return new WorkflowProcessHAManagerAdapter(masterAwareResourceManager, properties.isAutoStart());
        }

    }
}
