package ru.yandex.travel.workflow.ha;

import java.time.Duration;

import javax.validation.constraints.Positive;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "high-availability", ignoreUnknownFields = false)
@Getter
@Setter
public class HAConfigurationProperties {
    private boolean enabled;

    private Duration stopDuration;

    private Duration promoteDuration;

    private Duration retryAcquireMasterLockDuration;

    private Duration masterLockPingDuration;

    private Duration masterLockInitialPingDelayDuration;

    @Positive
    private int masterPingQueryTimeoutSeconds;
}
