package ru.yandex.travel.workflow.ha;

import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@AllArgsConstructor
@Slf4j
public class WorkflowProcessHAManagerAdapter implements InitializingBean, DisposableBean {

    private final MasterAwareResourceManager delegate;
    private final boolean autoStart;

    @Override
    public void destroy() throws Exception {
        delegate.prepareToStandby();
        delegate.stopAll();
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        log.info("HA Manager Adapter Started. Promoting to master automatically: {}", autoStart);
        if (autoStart) {
            delegate.promotedToMaster();
        }
    }
}
