package ru.yandex.travel.workflow.repository;

import java.time.Instant;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import ru.yandex.travel.workflow.entities.ClientCall;

public interface ClientCallRepository extends JpaRepository<ClientCall, String> {

    @Modifying
    @Query("DELETE FROM ClientCall c WHERE c.createdAt < :moment")
    void cleanupClientCalls(@Param("moment") Instant moment);
}
