package ru.yandex.travel.workflow.repository;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

import ru.yandex.travel.workflow.EWorkflowState;

public interface CustomizedWorkflowRepository<T> {

    List<UUID> findWorkflowsToBeScheduled(Set<UUID> idsToExclude, int poolId, int limit);

    public Map<UUID, Integer> findWorkflowsToBeScheduledByPools(Set<UUID> idsToExclude,
                                                                int defaultPoolId,
                                                                Map<Integer, Integer> poolLimits);

    List<UUID> findWorkflowsToBeScheduled(Set<UUID> idsToExclude, Set<Integer> excludePoolIds, int limit);

    Integer countWorkflowsToBeScheduled(Set<UUID> idsToExclude);

    // map: poolId -> workflows
    Map<Integer, Integer> countWorkflowsToBeScheduledPerPoolId(Set<UUID> idsToExclude);

    List<UUID> findSupervisedRunningWorkflows(UUID workflowId);

    List<UUID> findSupervisedWorkflowsWithState(UUID workflowId, EWorkflowState state);

    // we intercept and enhance these save operations to automatically assign processing pool ids to workflows
    <S extends T> S save(S entity);

    <S extends T> S saveAndFlush(S entity);

    <S extends T> List<S> saveAll(Iterable<S> entities);
}
