package ru.yandex.travel.workflow.repository;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import ru.yandex.travel.workflow.entities.SingleOperation;

public interface SingleOperationRepository extends JpaRepository<SingleOperation, UUID> {

    Set<UUID> NO_EXCLUDE_IDS = Set.of(UUID.fromString("00000000-0000-0000-0000-000000000000"));

    @Query("SELECT o.id FROM SingleOperation o WHERE o.commitSent = false " +
            "AND o.scheduledAt < ?1 AND o.id NOT IN ?2 ORDER BY o.scheduledAt")
    List<UUID> findIdsToSchedule(Instant now, Collection<UUID> excludeIds, Pageable pageable);

    @Query("SELECT count(o.id) FROM SingleOperation o WHERE o.commitSent = false " +
            "AND o.scheduledAt < ?1 AND o.id NOT IN ?2")
    Long countOperationsToSchedule(Instant now, Collection<UUID> excludeIds);

    List<SingleOperation> findAllByUniqueName(String operationUniqueName);
}
