package ru.yandex.travel.workflow.repository;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import ru.yandex.travel.workflow.EWorkflowEventState;
import ru.yandex.travel.workflow.entities.WorkflowEvent;

public interface WorkflowEventRepository extends JpaRepository<WorkflowEvent, Long> {
    Optional<WorkflowEvent> findFirstByWorkflowIdAndStateOrderByCreatedAtDesc(UUID workflowId,
                                                                              EWorkflowEventState workflowState);

    Optional<WorkflowEvent> findFirstByWorkflowIdAndStateOrderByCreatedAtAsc(UUID workflowId,
                                                                             EWorkflowEventState workflowState);

    List<WorkflowEvent> findAllByWorkflowId(UUID workflowId);

    @Query(value = "SELECT e.id, e.state FROM WorkflowEvent e WHERE e.id in (?1)")
    List<Object[]> pollEventStatus(Set<Long> eventIds);

    @Query(value = "select count(1) from workflow_events we inner join workflows w on we.workflow_id = w.id where " +
            " w.state <> '1' and we.state = '1'", nativeQuery = true)
    long countHangingWorkflowEvents();

    long countByWorkflowIdAndStateEquals(UUID workflowId, EWorkflowEventState workflowEventState);

    @Query(value = "select count(*) from workflow_events we inner join workflows w on we.workflow_id = w.id where " +
            " w.state = '1' and we.state = '1'", nativeQuery = true)
    long countPendingWorkflowEvents();

    long countByStateEquals(EWorkflowEventState state);
}
