package ru.yandex.travel.workflow.repository;

import java.util.List;
import java.util.Optional;
import java.util.UUID;

import javax.persistence.LockModeType;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import ru.yandex.travel.workflow.EWorkflowState;
import ru.yandex.travel.workflow.entities.Workflow;

public interface WorkflowRepository extends JpaRepository<Workflow, UUID>, CustomizedWorkflowRepository<Workflow> {

    @Lock(LockModeType.PESSIMISTIC_FORCE_INCREMENT)
    @Query("select w.state from Workflow w where w.id = :id")
    EWorkflowState getStateWithPessimisticForceIncrementLock(@Param("id") UUID id);

    @Lock(LockModeType.OPTIMISTIC_FORCE_INCREMENT)
    @Query("SELECT w FROM Workflow w WHERE w.id = :id")
    Optional<Workflow> getWorkflowWithOptimisticLockForced(@Param("id") UUID id);

    @Modifying
    @Query("update Workflow w set w.state = :newState, w.version = w.version + 1 " +
            "where w.id = :id and w.state = :oldState")
    int compareAndSetWorkflowState(@Param("id") UUID id, @Param("oldState") EWorkflowState oldState,
                                   @Param("newState") EWorkflowState newState);

    List<Workflow> findAllByEntityType(String entityType);

    @Modifying
    @Query(value = "update Workflow w set w.state = :newState, w.version = w.version + 1 " +
            "where w.id in (:workflowIds) and w.state = :oldState")
    void batchCompareAndSetWorkflowState(@Param("workflowIds") List<UUID> workflowIds,
                                         @Param("oldState") EWorkflowState oldState,
                                         @Param("newState") EWorkflowState newState);

    @Query(value = "select wf.entityType, wf.state, count(wf) from Workflow wf group by wf.entityType, wf.state")
    List<Object[]> countWorkflowByStateAndEntityType();

    @Query(value = "select wf.state, count(wf) from Workflow wf group by wf.state")
    List<Object[]> countWorkflowByState();
}
