package ru.yandex.travel.workflow.repository;

import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.workflow.WorkflowProcessingProperties;
import ru.yandex.travel.workflow.WorkflowProcessingProperties.ProcessingPools;

@Configuration
@EnableConfigurationProperties(WorkflowProcessingProperties.class)
public class WorkflowRepositoryConfiguration {
    @Bean
    public WorkflowRepositoryProcessingPoolsConfig workflowRepositoryProcessingPoolsConfig(
            WorkflowProcessingProperties properties
    ) {
        ProcessingPools settings = properties.getProcessingPools();
        Map<String, Integer> typeToPoolIdMapping = settings.getPools().entrySet().stream()
                .flatMap(entry -> entry.getValue().getEntityTypes().stream()
                        .map(entityType -> Map.entry(entityType, entry.getKey())))
                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new WorkflowRepositoryProcessingPoolsConfig(settings.getDefaultPoolId(), typeToPoolIdMapping);
    }
}
