package ru.yandex.travel.workflow.repository;

import java.util.Map;

import com.google.common.collect.ImmutableMap;

public class WorkflowRepositoryProcessingPoolsConfig {
    private final int defaultProcessingPoolId;
    private final Map<String, Integer> entityTypeToProcessingPoolIdMapping;

    public WorkflowRepositoryProcessingPoolsConfig(int defaultProcessingPoolId,
                                                   Map<String, Integer> entityTypeToProcessingPoolIdMapping) {
        this.defaultProcessingPoolId = defaultProcessingPoolId;
        this.entityTypeToProcessingPoolIdMapping = ImmutableMap.copyOf(entityTypeToProcessingPoolIdMapping);
    }

    public int getProcessingPoolId(String entityType) {
        return entityTypeToProcessingPoolIdMapping.getOrDefault(entityType, defaultProcessingPoolId);
    }
}
