package ru.yandex.travel.workflow.single_operation;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

import com.google.common.base.Preconditions;

public abstract class SimpleSingleOperationRunner<I, O> implements SingleOperationRunner<I, O> {
    private final Class<I> inputClass;

    protected SimpleSingleOperationRunner() {
        inputClass = determineInputClass();
    }

    private Class<I> determineInputClass() {
        Class<?> runnerClass = getClass();
        Preconditions.checkState(runnerClass.getSuperclass() == SimpleSingleOperationRunner.class ||
                        runnerClass.getSuperclass() == SimpleSingleOperationRunner.Void.class,
                "Unsupported runner hierarchy for %s", runnerClass.getName());
        // will work only for direct descendants, see https://stackoverflow.com/a/25974010 for a more complex approach
        Type superClassInfo = runnerClass.getGenericSuperclass();
        Preconditions.checkState(superClassInfo instanceof ParameterizedType,
                "Unexpected generic info type: type=%s, value=%s",
                superClassInfo.getTypeName(), superClassInfo);
        Type[] args = ((ParameterizedType) superClassInfo).getActualTypeArguments();
        Preconditions.checkState(args.length > 0, "Not enough type args: %s", args.length);
        Preconditions.checkState(args[0] instanceof Class, "The first type parameter isn't a class: %s", args[0]);
        @SuppressWarnings("unchecked")
        var type = (Class<I>) args[0];
        return type;
    }

    @Override
    public Class<I> getInputClass() {
        return inputClass;
    }

    public abstract static class Void<I> extends SimpleSingleOperationRunner<I, java.lang.Void> {
        @Override
        public java.lang.Void runOperation(I params) {
            runVoidOperation(params);
            return null;
        }

        protected abstract void runVoidOperation(I params);
    }
}
