package ru.yandex.travel.yt_lucene_index;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Parser;

public class ListPersistentConfig<ValueClass, ProtoClass extends GeneratedMessageV3> extends BasePersistentConfig<ProtoClass> {
    private final AtomicReference<List<ValueClass>> listRef = new AtomicReference<>();

    public ListPersistentConfig(YtLuceneIndexParams params, String name, Supplier<ProtoClass.Builder> builderSupplier,
                                Function<ProtoClass, ValueClass> valueGetter,
                                Function<List<ValueClass>, List<ValueClass>> listModifier) {
        super(params, name, builderSupplier);
        setIndexUpdateHandler(() -> {
            List<ValueClass> newList = new ArrayList<>();
            Parser<ProtoClass> parser = (Parser<ProtoClass>) builderSupplier.get().buildPartial().getParserForType();
            forEachProtoRecord(parser, proto -> {
                newList.add(valueGetter.apply(proto));
            });
            List<ValueClass> newModifiedList = listModifier.apply(newList);
            log.info("Got new list, size {}", newModifiedList.size());
            listRef.set(ImmutableList.copyOf(newModifiedList));
        });
    }

    public List<ValueClass> getAll() {
        List<ValueClass> list = listRef.get();
        if (list == null) {
            throw new IllegalStateException("PersistentConfig '" + name + "' is not ready");
        }
        return list;
    }
}
