package ru.yandex.travel.yt_lucene_index

import org.apache.lucene.document.Document
import org.apache.lucene.search.Query
import javax.annotation.PostConstruct
import javax.annotation.PreDestroy
import com.google.protobuf.Parser
import com.google.protobuf.GeneratedMessageV3

abstract class LuceneIndexService<T>(
    params: YtLuceneIndexParams,
    luceneIndexBuilder: LuceneIndexBuilder<T>,
    luceneIndexName: String
) {
    protected val luceneIndex: YtLuceneIndex = luceneIndexBuilder.build(params, luceneIndexName, ::documentProducer)

    protected abstract fun documentProducer(row: T): Iterable<Document>

    @PostConstruct
    fun init() {
        luceneIndex.start()
    }

    @PreDestroy
    fun destroy() {
        luceneIndex.stop()
    }

    fun isReady(): Boolean {
        return luceneIndex.isReady
    }

    protected fun searchOne(query: Query): Document? {
        return luceneIndex.search { searcher ->
            val topDocs = searcher.search(query, 1)

            if (topDocs.totalHits < 1) {
                return@search null
            }

            searcher.doc(topDocs.scoreDocs[0].doc)
        }
    }
}
