package ru.yandex.travel.yt_lucene_index;

import java.util.Collections;
import java.util.function.Consumer;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;

import ru.yandex.inside.yt.kosher.tables.types.NativeProtobufEntryType;
import ru.yandex.inside.yt.kosher.utils.ProtoUtils;

/* This class stores protobuf as is w/o any indexing */
public class NativeProtobufPlainYtLuceneIndex<ProtoClass extends Message> extends BaseYtLuceneIndex<ProtoClass> {
    private static final String FIELD_PROTO = "p";

    public NativeProtobufPlainYtLuceneIndex(YtLuceneIndexParams params, String name,
                                            Class<ProtoClass> protoClass) {
        super(params, name, ProtobufIndexVersionBuilder.build(ProtoUtils.newBuilder(protoClass)), (proto) -> {
            Document document = new Document();
            document.add(new StoredField(FIELD_PROTO, proto.toByteArray()));
            return Collections.singletonList(document);
        }, new NativeProtobufEntryType<>(protoClass));
        setKeepIndexOpened(false);
    }

    public void forEachProtoRecord(Parser<ProtoClass> parser, Consumer<ProtoClass> consumer) {
        forEachDocument(doc -> {
            try {
                consumer.accept(parser.parseFrom(doc.getField(FIELD_PROTO).binaryValue().bytes));
            } catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        });
    }
}
