package ru.yandex.travel.yt_lucene_index;

import java.util.function.Function;

import com.google.protobuf.Message;
import org.apache.lucene.document.Document;

import ru.yandex.inside.yt.kosher.tables.types.NativeProtobufEntryType;
import ru.yandex.inside.yt.kosher.utils.ProtoUtils;

public class NativeProtobufYtLuceneIndex<ProtoClass extends Message> extends BaseYtLuceneIndex<ProtoClass> {
    public NativeProtobufYtLuceneIndex(YtLuceneIndexParams params, String name, Class<ProtoClass> protoClass,
                                       Function<ProtoClass, Iterable<Document>> documentProducer) {
        super(params, name, ProtobufIndexVersionBuilder.build(ProtoUtils.newBuilder(protoClass)), documentProducer, new NativeProtobufEntryType<>(protoClass));
    }
}
