package ru.yandex.travel.yt_lucene_index;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.protobuf.Message;

public class ProtobufIndexVersionBuilder {
    public static int build(Message.Builder builder) {
        byte[] descriptorBytes = builder.getDescriptorForType().toProto().toByteArray();
        Hasher hasher = Hashing.murmur3_32().newHasher();
        hasher.putBytes(descriptorBytes);
        return hasher.hash().asInt();
    }
}
