package ru.yandex.travel.yt_lucene_index;

import java.util.function.Function;

import com.google.protobuf.Message;
import org.apache.lucene.document.Document;

import ru.yandex.inside.yt.kosher.tables.YTableEntryTypes;
import ru.yandex.inside.yt.kosher.utils.ProtoUtils;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

public class ProtobufYtLuceneIndex<ProtoClass extends Message> extends BaseYtLuceneIndex<YTreeMapNode> {
    public ProtobufYtLuceneIndex(YtLuceneIndexParams params, String name, Class<ProtoClass> protoClass,
                                 Function<ProtoClass, Iterable<Document>> documentProducer) {
        super(params, name, ProtobufIndexVersionBuilder.build(ProtoUtils.newBuilder(protoClass)), (YTreeMapNode row) -> {
            ProtoClass.Builder builder = ProtoUtils.newBuilder(protoClass);
            ProtoFiller.fillByYtNode(row, builder, "");
            var proto = builder.build();

            return documentProducer.apply((ProtoClass) proto);
        }, YTableEntryTypes.YSON);
    }
}
