package ru.yandex.travel.yt_lucene_index

import com.google.protobuf.Message
import org.apache.lucene.document.Document

class ProtobufYtLuceneIndexBuilder<ProtoClass : Message> : LuceneIndexBuilder<ProtoClass> {
    private var protoClass: Class<ProtoClass>? = null

    fun setProtoClass(protoClass: Class<ProtoClass>): ProtobufYtLuceneIndexBuilder<ProtoClass> {
        this.protoClass = protoClass

        return this
    }

    override fun build(
        params: YtLuceneIndexParams,
        luceneIndexName: String,
        documentProducer: (row: ProtoClass) -> Iterable<Document>
    ): YtLuceneIndex {
        return protoClass?.let {
            ProtobufYtLuceneIndex(params, luceneIndexName, it, documentProducer)
        } ?: throw IllegalStateException("Proto class for protobuf lucene index not specified")
    }
}
