### YT Lucene Index

В этом пакете собраны классы для кэширования данных из YT-таблиц в индексе Lucene.

Цель - обеспечить запуск и работу приложения при недоступном YT (при наличии данных в индексе)

### Как это работает

Данные загружаются из YT-таблицы и складываются в индекс Lucene.
Периодически производится проверка, и если YT-таблица обновилась, данные снова загружаются в индекс.
Если во время старта приложения YT оказался недоступен, но индекс есть - то приложение
запускается и пользуется данными из индекса.

### Классы

#### `YtLuceneIndexParams`

Параметры индексации:
* Список YT-кластеров для чтения таблицы. Выбирается кластер с самой новой версией таблицы (по `@modification_time`).
* Путь до таблицы на YT
* Путь до локальной папки с индексом.
* Период проверки изменений в YT

#### `YtLuceneIndex` и наследники

Это классы для организации произвольного индекса поверх YT-таблицы.

Если вам нужно организовать поиск по большой YT-таблице, с возможностью поиска по разным ключам, в том числе составным - вам сюда.

`YtLuceneIndex` - это общий интерфейс.
Наследники:
* `BaseYtLuceneIndex` - база для реализации, параметризуется типом записи, читаемой из YT
* `YsonYtLuceneIndex` - реализация индекса, оперирующая YSON-записями (`YTreeMapNode`)
* `NativeProtobufYtLuceneIndex` - реализация индекса, оперирующая YT-нативными протобуфами
* `NativeProtobufPlainYtLuceneIndex` - специальная реализация индекса, которая складывает протобуфы в индекс "as is",
без возможности поиска по полям, но с возможностью проитерировать все записи
* `ProtobufYtLuceneIndex` - реализация индекса, оперирующая протобуфами, с возможность поиска по полям. Подходит для таблиц в YT с YSON-полями.

#### `MapPersistentConfig` и `ListPersistentConfig`

Это классы для хранения конфигурации в виде Map и List соответственно. Внутри используют `YsonYtLuceneIndex`.

Если вам нужно в памяти хранить небольшую YT таблицу, и иметь возможность быстро получать все записи - вам сюда.

Предполагается, что экземпляры этих классов создаются как bean-ы, т.к. эти классы используют @PostConstruct и @PreDestroy.

* `BasePersistentConfig` - базовый класс, обеспечивает трансляцию Yson в Protobuf и сохранение protobuf в индекс.
* `MapPersistentConfig` - Хранит данные таблицы в памяти в виде Map с доступом по ключу.
* `ListPersistentConfig` - Хранит данные таблицы в памяти в виде List с возможностью получить весь список.


#### TODO
 * `BasePersistentConfig` и `NativeProtobufPlainYtLuceneIndex` имеют одинаковый индекс внутри - это бы дедуплицировать.
 * Разложить по подпакетам
