package ru.yandex.travel.yt_lucene_index;

import java.io.IOException;
import java.util.function.Consumer;

import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;


public interface YtLuceneIndex {
    interface SearchExecutor<T> {
        T execute(IndexSearcher searcher) throws IOException;
    }

    interface IndexUpdateHandler {
        void process();
    }

    /**
     * This method is called right after index update, just before closing index (if keepIndexOpened = false).
     */
    void setIndexUpdateHandler(IndexUpdateHandler indexUpdateHandler);

    /**
     * Specifies if index should be kept open or not.
     *
     * true (by default) means that index is accessible at any time by calling search/forEachDocument
     *
     * false means that index is only accessible during call to IndexUpdateHandler.
     */
    void setKeepIndexOpened(boolean keepIndexOpened);

    /**
     * This method should be called for index to start operating
     */
    void start();

    /**
     * opposite of start()
     */
    void stop();

    /**
     * Main method for executing search in index.
     * Executor should be passed, which accepts searcher, which may be used for searching.
     * May throw RuntimeException if index is not ready.
     */
    <T> T search(SearchExecutor<T> executor);

    /**
     * Iterates all documents in index.
     * May throw RuntimeException if index is not ready.
     */
    void forEachDocument(Consumer<Document> consumer);

    /**
     * Checks if index is ready.
     */
    boolean isReady();
}
