package ru.yandex.travel.yt_lucene_index;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

import javax.validation.constraints.NotNull;

import lombok.Data;

@Data
public class YtLuceneIndexParams {
    private Duration updateInterval = Duration.ofMinutes(30);
    private Duration shutdownTimeout = Duration.ofSeconds(10);
    private List<String> proxy = new ArrayList<>();
    @NotNull
    private String token;
    @NotNull
    private String tablePath;
    @NotNull
    private String indexPath;
    private boolean preload = false;
}
